/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.jcajce;

import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsHMAC;
import org.bouncycastle.tls.crypto.TlsHash;
import org.bouncycastle.util.Arrays;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class JcaSSL3HMAC
implements TlsHMAC {
    private static final byte IPAD_BYTE = 54;
    private static final byte OPAD_BYTE = 92;
    private static final byte[] IPAD = JcaSSL3HMAC.genPad((byte)54, 48);
    private static final byte[] OPAD = JcaSSL3HMAC.genPad((byte)92, 48);
    private TlsHash digest;
    private final int digestSize;
    private final int internalBlockSize;
    private int padLength;
    private byte[] secret;

    JcaSSL3HMAC(TlsHash tlsHash, int n, int n2) {
        this.digest = tlsHash;
        this.digestSize = n;
        this.internalBlockSize = n2;
        this.padLength = n == 20 ? 40 : 48;
    }

    @Override
    public void setKey(byte[] byArray, int n, int n2) {
        this.secret = TlsUtils.copyOfRangeExact(byArray, n, n + n2);
        this.reset();
    }

    @Override
    public void update(byte[] byArray, int n, int n2) {
        this.digest.update(byArray, n, n2);
    }

    @Override
    public byte[] calculateMAC() {
        byte[] byArray = this.digest.calculateHash();
        this.digest.update(this.secret, 0, this.secret.length);
        this.digest.update(OPAD, 0, this.padLength);
        this.digest.update(byArray, 0, byArray.length);
        byte[] byArray2 = this.digest.calculateHash();
        this.reset();
        return byArray2;
    }

    @Override
    public void calculateMAC(byte[] byArray, int n) {
        byte[] byArray2 = this.calculateMAC();
        System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
    }

    @Override
    public int getInternalBlockSize() {
        return this.internalBlockSize;
    }

    @Override
    public int getMacLength() {
        return this.digestSize;
    }

    @Override
    public void reset() {
        this.digest.reset();
        this.digest.update(this.secret, 0, this.secret.length);
        this.digest.update(IPAD, 0, this.padLength);
    }

    private static byte[] genPad(byte by, int n) {
        byte[] byArray = new byte[n];
        Arrays.fill(byArray, by);
        return byArray;
    }
}

