/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.barbarianassault;

import java.time.Duration;
import java.time.Instant;
import javax.inject.Inject;
import lombok.Generated;
import lombok.NonNull;
import net.runelite.client.plugins.barbarianassault.Role;
import net.runelite.client.util.RSTimeUnit;

class Round {
    private final Instant roundStartTime;
    private final Role roundRole;
    private boolean runnersKilled;
    private boolean rangersKilled;
    private boolean healersKilled;
    private boolean fightersKilled;

    @Inject
    public Round(@NonNull Role role) {
        if (role == null) {
            throw new NullPointerException("role is marked non-null but is null");
        }
        this.roundRole = role;
        this.roundStartTime = Instant.now().plus(Duration.of(2L, RSTimeUnit.GAME_TICKS));
    }

    public int getTimeToChange() {
        return 30 + (int)Duration.between(Instant.now(), this.roundStartTime).getSeconds() % 30;
    }

    @Generated
    public Role getRoundRole() {
        return this.roundRole;
    }

    @Generated
    public boolean isRunnersKilled() {
        return this.runnersKilled;
    }

    @Generated
    public void setRunnersKilled(boolean runnersKilled) {
        this.runnersKilled = runnersKilled;
    }

    @Generated
    public boolean isRangersKilled() {
        return this.rangersKilled;
    }

    @Generated
    public void setRangersKilled(boolean rangersKilled) {
        this.rangersKilled = rangersKilled;
    }

    @Generated
    public boolean isHealersKilled() {
        return this.healersKilled;
    }

    @Generated
    public void setHealersKilled(boolean healersKilled) {
        this.healersKilled = healersKilled;
    }

    @Generated
    public boolean isFightersKilled() {
        return this.fightersKilled;
    }

    @Generated
    public void setFightersKilled(boolean fightersKilled) {
        this.fightersKilled = fightersKilled;
    }
}

