/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.tithefarm;

import java.time.Duration;
import java.time.Instant;
import lombok.Generated;
import net.runelite.api.GameObject;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.plugins.tithefarm.TitheFarmPlantState;
import net.runelite.client.plugins.tithefarm.TitheFarmPlantType;

class TitheFarmPlant {
    private static final Duration PLANT_TIME = Duration.ofMinutes(1L);
    private Instant planted = Instant.now();
    private final TitheFarmPlantState state;
    private final TitheFarmPlantType type;
    private final GameObject gameObject;
    private final WorldPoint worldLocation;

    TitheFarmPlant(TitheFarmPlantState state, TitheFarmPlantType type, GameObject gameObject) {
        this.state = state;
        this.type = type;
        this.gameObject = gameObject;
        this.worldLocation = gameObject.getWorldLocation();
    }

    public double getPlantTimeRelative() {
        Duration duration = Duration.between(this.planted, Instant.now());
        return duration.compareTo(PLANT_TIME) < 0 ? (double)duration.toMillis() / (double)PLANT_TIME.toMillis() : 1.0;
    }

    @Generated
    public Instant getPlanted() {
        return this.planted;
    }

    @Generated
    public void setPlanted(Instant planted) {
        this.planted = planted;
    }

    @Generated
    public TitheFarmPlantState getState() {
        return this.state;
    }

    @Generated
    public TitheFarmPlantType getType() {
        return this.type;
    }

    @Generated
    public GameObject getGameObject() {
        return this.gameObject;
    }

    @Generated
    public WorldPoint getWorldLocation() {
        return this.worldLocation;
    }
}

