/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.jcajce;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import javax.crypto.KeyGenerator;
import org.bouncycastle.jcajce.SecretKeyWithEncapsulation;
import org.bouncycastle.jcajce.spec.KEMExtractSpec;
import org.bouncycastle.jcajce.spec.KEMGenerateSpec;
import org.bouncycastle.jcajce.spec.MLKEMParameterSpec;
import org.bouncycastle.tls.NamedGroup;
import org.bouncycastle.tls.crypto.TlsAgreement;
import org.bouncycastle.tls.crypto.TlsKemConfig;
import org.bouncycastle.tls.crypto.TlsKemDomain;
import org.bouncycastle.tls.crypto.impl.jcajce.Exceptions;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;
import org.bouncycastle.tls.crypto.impl.jcajce.JceTlsMLKem;
import org.bouncycastle.tls.crypto.impl.jcajce.JceTlsSecret;
import org.bouncycastle.tls.crypto.impl.jcajce.KemUtil;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class JceTlsMLKemDomain
implements TlsKemDomain {
    protected final JcaTlsCrypto crypto;
    protected final String kemName;
    protected final boolean isServer;

    public JceTlsMLKemDomain(JcaTlsCrypto jcaTlsCrypto, TlsKemConfig tlsKemConfig) {
        this.crypto = jcaTlsCrypto;
        this.kemName = NamedGroup.getKemName(tlsKemConfig.getNamedGroup());
        this.isServer = tlsKemConfig.isServer();
    }

    public JceTlsSecret adoptLocalSecret(byte[] byArray) {
        return this.crypto.adoptLocalSecret(byArray);
    }

    @Override
    public TlsAgreement createKem() {
        return new JceTlsMLKem(this);
    }

    public JceTlsSecret decapsulate(PrivateKey privateKey, byte[] byArray) {
        try {
            KeyGenerator keyGenerator = this.crypto.getHelper().createKeyGenerator(this.kemName);
            keyGenerator.init(new KEMExtractSpec.Builder(privateKey, byArray, "DEF", 256).withNoKdf().build());
            SecretKeyWithEncapsulation secretKeyWithEncapsulation = (SecretKeyWithEncapsulation)keyGenerator.generateKey();
            return this.adoptLocalSecret(secretKeyWithEncapsulation.getEncoded());
        }
        catch (Exception exception) {
            throw Exceptions.illegalArgumentException("invalid key: " + exception.getMessage(), exception);
        }
    }

    public PublicKey decodePublicKey(byte[] byArray) throws IOException {
        return KemUtil.decodePublicKey(this.crypto, this.kemName, byArray);
    }

    public SecretKeyWithEncapsulation encapsulate(PublicKey publicKey) {
        try {
            KeyGenerator keyGenerator = this.crypto.getHelper().createKeyGenerator(this.kemName);
            keyGenerator.init(new KEMGenerateSpec.Builder(publicKey, "DEF", 256).withNoKdf().build());
            return (SecretKeyWithEncapsulation)keyGenerator.generateKey();
        }
        catch (Exception exception) {
            throw Exceptions.illegalArgumentException("invalid key: " + exception.getMessage(), exception);
        }
    }

    public byte[] encodePublicKey(PublicKey publicKey) throws IOException {
        return KemUtil.encodePublicKey(publicKey);
    }

    public KeyPair generateKeyPair() {
        try {
            KeyPairGenerator keyPairGenerator = this.crypto.getHelper().createKeyPairGenerator("ML-KEM");
            keyPairGenerator.initialize(MLKEMParameterSpec.fromName(this.kemName), this.crypto.getSecureRandom());
            return keyPairGenerator.generateKeyPair();
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw Exceptions.illegalStateException("unable to create key pair: " + generalSecurityException.getMessage(), generalSecurityException);
        }
    }

    public boolean isServer() {
        return this.isServer;
    }
}

